//m_shift.c
//shift transformation tables
#include "doomstat.h"

const char*	shiftxform;

const char french_shiftxform[] =
{
    0,
		1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
		11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
		21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
		31,
		' ', '!', '"', '#', '$', '%', '&',
		'"', // shift-'
		'(', ')', '*', '+',
		'?', // shift-,
		'_', // shift--
		'>', // shift-.
		'?', // shift-/
		'0', // shift-0
		'1', // shift-1
		'2', // shift-2
		'3', // shift-3
		'4', // shift-4
		'5', // shift-5
		'6', // shift-6
		'7', // shift-7
		'8', // shift-8
		'9', // shift-9
		'/',
		'.', // shift-;
		'<',
		'+', // shift-=
		'>', '?', '@',
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
		'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
		'[', // shift-[
		'!', // shift-backslash - OH MY GOD DOES WATCOM SUCK
		']', // shift-]
		'"', '_',
		'\'', // shift-`
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
		'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
		'{', '|', '}', '~', 127

};

const char english_shiftxform[] =
{

    0,
		1, 2, 3, 4, 5, 6, 7, 8, 9, 10,
		11, 12, 13, 14, 15, 16, 17, 18, 19, 20,
		21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
		31,
		' ', '!', '"', '#', '$', '%', '&',
		'"', // shift-'
		'(', ')', '*', '+',
		'<', // shift-,
		'_', // shift--
		'>', // shift-.
		'?', // shift-/
		')', // shift-0
		'!', // shift-1
		'@', // shift-2
		'#', // shift-3
		'$', // shift-4
		'%', // shift-5
		'^', // shift-6
		'&', // shift-7
		'*', // shift-8
		'(', // shift-9
		':',
		':', // shift-;
		'<',
		'+', // shift-=
		'>', '?', '@',
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
		'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
		'[', // shift-[
		'!', // shift-backslash - OH MY GOD DOES WATCOM SUCK
		']', // shift-]
		'"', '_',
		'\'', // shift-`
		'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N',
		'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
		'{', '|', '}', '~', 127
};

void M_InitShiftXForm(void)
{
    if (language==french)
		shiftxform = french_shiftxform;
    else
		shiftxform = english_shiftxform;
}
